/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common;

import java.util.logging.Level;
import org.bukkit.Bukkit;

public class Common {
    public static final boolean IS_SPIGOT_SERVER = Bukkit.getVersion().contains("Spigot");
    public static final String MC_VERSION;
    private static final String MC_VERSION_PACKAGEPART;
    public static final String NMS_ROOT;
    public static final String CB_ROOT;
    public static final int VERSION = 148;

    static {
        String version = "";
        if (!Common.checkVersion(version)) {
            StringBuilder builder = new StringBuilder();
            int a = 0;
            while (a < 10) {
                int b = 0;
                while (b < 10) {
                    int c = 0;
                    while (c < 10) {
                        builder.setLength(0);
                        builder.append('v').append(a).append('_').append(b).append('_').append('R').append(c);
                        version = builder.toString();
                        if (Common.checkVersion(version)) {
                            c = 10;
                            b = 10;
                            a = 10;
                        }
                        ++c;
                    }
                    ++b;
                }
                ++a;
            }
        }
        MC_VERSION_PACKAGEPART = (MC_VERSION = version).isEmpty() ? "" : "." + MC_VERSION;
        NMS_ROOT = "net.minecraft.server" + MC_VERSION_PACKAGEPART;
        CB_ROOT = "org.bukkit.craftbukkit" + MC_VERSION_PACKAGEPART;
    }

    private static boolean checkVersion(String version) {
        try {
            if (version.isEmpty()) {
                Class.forName("net.minecraft.server.World");
            } else {
                Class.forName("net.minecraft.server." + version + ".World");
            }
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isMCVersionCompatible(String version) {
        return MC_VERSION.isEmpty() || version.equals(MC_VERSION);
    }

    public static int getVersion() {
        return 148;
    }

    public static void loadClasses(String ... classNames) {
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            try {
                Common.loadInner(Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not load class '" + className + "' - Update needed?");
            }
            ++n2;
        }
    }

    private static void loadInner(Class<?> clazz) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> subclass = classArray[n2];
            Common.loadInner(subclass);
            ++n2;
        }
    }

    protected static void handleReflectionMissing(String type, String name, Class<?> source) {
        String msg = String.valueOf(type) + " '" + name + "' does not exist in class file " + source.getSimpleName();
        Exception ex = new Exception(msg);
        StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            if (elem.getClassName().startsWith("com.bergerkiller.bukkit.common.reflection")) {
                Bukkit.getServer().getLogger().log(Level.SEVERE, "[BKCommonLib] " + msg + " (Update BKCommonLib?)");
                return;
            }
            ++n2;
        }
        ex.printStackTrace();
    }
}

