/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.cl.chlorek.SmoothPlot;

import com.gmail.cl.chlorek.SmoothPlot.CustomConfig;
import com.gmail.cl.chlorek.SmoothPlot.HandleWorldGuard;
import com.gmail.cl.chlorek.SmoothPlot.MainSmoothPlot;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.databases.ProtectionDatabaseException;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.sql.SQLException;
import java.util.Arrays;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class SmoothPlotListener
extends CustomConfig
implements Listener {
    Economy economy = null;

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    public SmoothPlotListener(MainSmoothPlot plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        boolean isEconomyPlugin = this.setupEconomy();
        if (!isEconomyPlugin) {
            MainSmoothPlot.log.info("Error getting economy plugin handler! SmoothPlot enabling failed!");
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        } else {
            MainSmoothPlot.log.info("Economy plugin found and is running successfully!");
        }
    }

    @EventHandler
    public void onPlayerSignUse(PlayerInteractEvent event) throws ProtectedRegion.CircularInheritanceException, ProtectionDatabaseException, SQLException, InvalidFlagFormat {
        Block block;
        Material material;
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK && ((material = (block = event.getClickedBlock()).getType()) == Material.SIGN_POST || material == Material.WALL_SIGN)) {
            Sign sign = (Sign)block.getState();
            String[] lines = sign.getLines();
            Player player = event.getPlayer();
            if (lines[0].equals(this.getConfig().getString("header"))) {
                if (player.hasPermission("smoothplot.plot." + lines[1])) {
                    WorldGuardPlugin wg = HandleWorldGuard.getWorldGuard();
                    ConfigurationSection cs = this.getConfig().getConfigurationSection(lines[1]);
                    if (cs == null) {
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not find specifed plot in the config file.");
                        return;
                    }
                    long cost = cs.getLong("cost");
                    double money = 0.0;
                    money = this.economy.getBalance(player.getName());
                    if (money >= (double)cost) {
                        int freePlotNumber = 0;
                        int i = 1;
                        while (i <= cs.getInt("max-plots-per-player")) {
                            RegionManager rm = wg.getRegionManager(block.getLocation().getWorld());
                            ProtectedRegion region = rm.getRegion(String.valueOf(player.getName()) + "-" + lines[1] + i);
                            if (!rm.hasRegion(String.valueOf(player.getName()) + "-" + lines[1] + i) && region == null) {
                                freePlotNumber = i;
                                break;
                            }
                            ++i;
                        }
                        if (freePlotNumber > 0) {
                            String[] materials = new String[32];
                            if (lines[2].contains(",")) {
                                materials = lines[2].split(",");
                            } else {
                                materials[0] = lines[2];
                            }
                            Location loc = block.getLocation();
                            Location selPos1 = null;
                            Location selPos2 = null;
                            int safeCounter = 0;
                            while (!Arrays.asList(materials).contains(Integer.toString(loc.getBlock().getTypeId()))) {
                                loc.setX(loc.getX() + 1.0);
                                if (++safeCounter <= cs.getInt("safe-size")) continue;
                                player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not create plot - the plot is too big!");
                                return;
                            }
                            safeCounter = 0;
                            while (Arrays.asList(materials).contains(Integer.toString(loc.getBlock().getTypeId()))) {
                                loc.setZ(loc.getZ() + 1.0);
                                if (++safeCounter <= cs.getInt("safe-size")) continue;
                                player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not create plot - the plot is too big!");
                                return;
                            }
                            loc.setZ(loc.getZ() - 1.0);
                            selPos1 = loc;
                            loc = block.getLocation();
                            safeCounter = 0;
                            while (!Arrays.asList(materials).contains(Integer.toString(loc.getBlock().getTypeId()))) {
                                loc.setX(loc.getX() - 1.0);
                                if (++safeCounter <= cs.getInt("safe-size")) continue;
                                player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not create plot - the plot is too big!");
                                return;
                            }
                            safeCounter = 0;
                            while (Arrays.asList(materials).contains(Integer.toString(loc.getBlock().getTypeId()))) {
                                loc.setZ(loc.getZ() - 1.0);
                                if (++safeCounter <= cs.getInt("safe-size")) continue;
                                player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not create plot - the plot is too big!");
                                return;
                            }
                            loc.setZ(loc.getZ() + 1.0);
                            selPos2 = loc;
                            RegionManager rm = wg.getRegionManager(block.getLocation().getWorld());
                            BlockVector bv1 = new BlockVector(selPos1.getX(), selPos1.getY() + (double)cs.getInt("expand-up"), selPos1.getZ());
                            BlockVector bv2 = new BlockVector(selPos2.getX(), selPos2.getY() - (double)cs.getInt("expand-down"), selPos2.getZ());
                            ProtectedCuboidRegion region = new ProtectedCuboidRegion(String.valueOf(player.getName()) + "-" + lines[1] + freePlotNumber, bv1, bv2);
                            rm.addRegion((ProtectedRegion)region);
                            DefaultDomain owners = new DefaultDomain();
                            owners.addPlayer(player.getName());
                            region.setOwners(owners);
                            if (!lines[3].isEmpty()) {
                                region.setParent(rm.getRegion(lines[3]));
                            }
                            if (this.getConfig().getBoolean("greet-msg")) {
                                String format = null;
                                format = this.getConfig().getString("greet-msg-format");
                                format = format.replaceAll("OWNER", player.getName());
                                StringFlag flag = DefaultFlag.GREET_MESSAGE;
                                region.setFlag((Flag)flag, (Object)flag.parseInput(wg, (CommandSender)player, format));
                            }
                            if (cs.getBoolean("tekkit-mode-plot")) {
                                DefaultDomain modMembers = new DefaultDomain();
                                modMembers.addPlayer("[BuildCraft]");
                                modMembers.addPlayer("[IndustrialCraft]");
                                modMembers.addPlayer("[RedPower]");
                                region.setMembers(modMembers);
                            }
                            rm.save();
                            block.setTypeId(0);
                            this.economy.withdrawPlayer(player.getName(), (double)cost);
                            player.sendMessage(ChatColor.AQUA + "[SmoothPlot] This plot is now yours!");
                        } else {
                            player.sendMessage(ChatColor.RED + "[SmoothPlot] You have reached the maximum amount of plots of this type!");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] You need more money! Your cash: " + money + "/" + cost);
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] You are not allowed to buy '" + lines[1] + "' plots!");
                }
            } else if (lines[0].equalsIgnoreCase(this.getConfig().getString("sell_header"))) {
                WorldGuardPlugin wg = HandleWorldGuard.getWorldGuard();
                RegionManager rm = wg.getRegionManager(block.getLocation().getWorld());
                ConfigurationSection cs = this.getConfig().getConfigurationSection(lines[1]);
                if (cs == null) {
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not find specifed plot in the config file.");
                    return;
                }
                Location loc = block.getLocation();
                int plotForSale = 0;
                ProtectedRegion region = null;
                int i = 1;
                while (i <= cs.getInt("max-plots-per-player")) {
                    BlockVector2D pt;
                    region = rm.getRegion(String.valueOf(lines[2]) + "-" + lines[1] + i);
                    if (region != null && region.contains(pt = new BlockVector2D(loc.getX(), loc.getZ()))) {
                        plotForSale = i;
                        break;
                    }
                    ++i;
                }
                if (plotForSale > 0) {
                    String[] strCost;
                    double cost;
                    double money = 0.0;
                    money = this.economy.getBalance(player.getName());
                    if (money >= (cost = Double.parseDouble((strCost = lines[3].split(":"))[1]))) {
                        int freePlotNumber = 0;
                        int i2 = 1;
                        while (i2 <= cs.getInt("max-plots-per-player")) {
                            ProtectedRegion tRegion = rm.getRegion(String.valueOf(player.getName()) + "-" + lines[1] + i2);
                            if (!rm.hasRegion(String.valueOf(player.getName()) + "-" + lines[1] + i2) && tRegion == null) {
                                freePlotNumber = i2;
                                break;
                            }
                            ++i2;
                        }
                        if (freePlotNumber > 0) {
                            BlockVector bv1 = region.getMinimumPoint();
                            BlockVector bv2 = region.getMaximumPoint();
                            ProtectedCuboidRegion newRegion = new ProtectedCuboidRegion(String.valueOf(player.getName()) + "-" + lines[1] + freePlotNumber, bv1, bv2);
                            rm.addRegion((ProtectedRegion)newRegion);
                            DefaultDomain newOwner = new DefaultDomain();
                            newOwner.addPlayer(player.getName());
                            newRegion.setOwners(newOwner);
                            ProtectedRegion parent = region.getParent();
                            newRegion.setParent(parent);
                            if (this.getConfig().getBoolean("greet-msg")) {
                                String format = null;
                                format = this.getConfig().getString("greet-msg-format");
                                format = format.replaceAll("OWNER", player.getName());
                                StringFlag flag = DefaultFlag.GREET_MESSAGE;
                                newRegion.setFlag((Flag)flag, (Object)flag.parseInput(wg, (CommandSender)player, format));
                            }
                            if (cs.getBoolean("tekkit-mode")) {
                                DefaultDomain modMembers = new DefaultDomain();
                                modMembers.addPlayer("[BuildCraft]");
                                modMembers.addPlayer("[IndustrialCraft]");
                                modMembers.addPlayer("[RedPower]");
                                newRegion.setMembers(modMembers);
                            }
                            rm.removeRegion(String.valueOf(lines[2]) + "-" + lines[1] + plotForSale);
                            block.setTypeId(0);
                            rm.save();
                            this.economy.withdrawPlayer(player.getName(), cost);
                            this.economy.depositPlayer(lines[2], cost);
                            player.sendMessage(ChatColor.GREEN + "[SmoothPlot] You have just bought this plot for " + cost + "!");
                        } else {
                            player.sendMessage(ChatColor.RED + "[SmoothPlot] You have reached the maximum amount of plots of this type!");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] You need more money! Your cash: " + money + "/" + cost);
                    }
                } else {
                    event.getPlayer().sendMessage(ChatColor.RED + "[SmoothPlot] Invalid sign - no plot for sale!");
                }
            } else if (lines[0].equalsIgnoreCase(this.getConfig().getString("invite_header"))) {
                WorldGuardPlugin wg = HandleWorldGuard.getWorldGuard();
                RegionManager rm = wg.getRegionManager(block.getLocation().getWorld());
                ConfigurationSection cs = this.getConfig().getConfigurationSection(lines[2]);
                if (cs == null) {
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not find specifed plot in the config file.");
                    return;
                }
                Location loc = block.getLocation();
                int plotNumber = 0;
                ProtectedRegion region = null;
                int i = 1;
                while (i <= cs.getInt("max-plots-per-player")) {
                    BlockVector2D pt;
                    region = rm.getRegion(String.valueOf(lines[1]) + "-" + lines[2] + i);
                    if (region != null && region.contains(pt = new BlockVector2D(loc.getX(), loc.getZ()))) {
                        plotNumber = i;
                        break;
                    }
                    ++i;
                }
                if (plotNumber > 0) {
                    if (lines[3].equalsIgnoreCase(player.getName())) {
                        DefaultDomain members = region.getMembers();
                        members.addPlayer(lines[3]);
                        region.setMembers(members);
                        block.breakNaturally();
                        rm.save();
                        player.sendMessage(ChatColor.GREEN + "[SmoothPlot] You are a new member of this plot now!");
                    } else {
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] You are not invited to this plot!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] Invalid invite-sign! Plot not found!");
                }
            }
        }
    }

    @EventHandler
    public void onPlayerSignPlace(SignChangeEvent event) {
        Material m = event.getBlock().getType();
        if (m == Material.SIGN_POST || m == Material.WALL_SIGN) {
            String[] lines = event.getLines();
            if (lines[0].equalsIgnoreCase(this.getConfig().getString("header"))) {
                if (event.getPlayer().hasPermission("smoothplot.sign.plot")) {
                    if (!lines[1].isEmpty() || !lines[2].isEmpty()) {
                        event.getPlayer().sendMessage(ChatColor.GREEN + "[SmoothPlot] SmoothPlot-Sign created successfully!");
                    } else {
                        Player player = event.getPlayer();
                        event.setCancelled(true);
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] Syntax error: Example...");
                        player.sendMessage(ChatColor.RED + "1. " + this.getConfig().getString("header"));
                        player.sendMessage(ChatColor.RED + "2. <plot-type name>");
                        player.sendMessage(ChatColor.RED + "3. <border material ID(s) separated with colons>");
                        player.sendMessage(ChatColor.RED + "4. [parent region]");
                    }
                } else {
                    event.setCancelled(true);
                    event.getPlayer().sendMessage(ChatColor.RED + "[SmoothPlot] You are not allowed to place SmoothPlot plot-signs!");
                }
            } else if (lines[0].equalsIgnoreCase(this.getConfig().getString("sell_header"))) {
                Player player = event.getPlayer();
                if (player.hasPermission("smoothplot.sign.sell")) {
                    if (!lines[3].isEmpty() && !lines[1].isEmpty()) {
                        ConfigurationSection cs = this.getConfig().getConfigurationSection(lines[1]);
                        if (cs == null) {
                            player.sendMessage(ChatColor.RED + "[SmoothPlot] Could not find specifed plot in the config file.");
                            event.setCancelled(true);
                            return;
                        }
                        Block block = event.getBlock();
                        Location loc = block.getLocation();
                        WorldGuardPlugin wg = HandleWorldGuard.getWorldGuard();
                        RegionManager rm = wg.getRegionManager(loc.getWorld());
                        int plotForSale = 0;
                        ProtectedRegion region = null;
                        int i = 1;
                        while (i <= cs.getInt("max-plots-per-player")) {
                            BlockVector2D pt;
                            region = rm.getRegion(String.valueOf(player.getName()) + "-" + lines[1] + i);
                            if (region != null && region.contains(pt = new BlockVector2D(loc.getX(), loc.getZ()))) {
                                plotForSale = i;
                                break;
                            }
                            ++i;
                        }
                        if (plotForSale > 0) {
                            event.setLine(2, event.getPlayer().getName());
                            event.setLine(3, "Cost:" + lines[3]);
                            player.sendMessage(ChatColor.GREEN + "[SmoothPlot] SmoothPlot-SellSign created successfully!");
                        } else {
                            event.setCancelled(true);
                            player.sendMessage(ChatColor.RED + "[SmoothPlot] There isn't any plot of this type!");
                        }
                    } else {
                        event.setCancelled(true);
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] Invalid sign-syntax - example:");
                        player.sendMessage(ChatColor.RED + "1. " + this.getConfig().getString("sell_header"));
                        player.sendMessage(ChatColor.RED + "2. <Plot type-name>");
                        player.sendMessage(ChatColor.RED + "3. <leave empty line>");
                        player.sendMessage(ChatColor.RED + "4. <price>");
                    }
                } else {
                    event.setCancelled(true);
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] You are not allowed to place this sign!");
                }
            } else if (lines[0].equalsIgnoreCase(this.getConfig().getString("invite_header"))) {
                Player player = event.getPlayer();
                if (player.hasPermission("smoothplot.sign.invite")) {
                    if (!lines[1].isEmpty() && !lines[2].isEmpty()) {
                        event.setLine(3, event.getLine(1));
                        event.setLine(1, player.getName());
                        player.sendMessage(ChatColor.GREEN + "[SmoothPlot] SmoothPlot-InviteSign created successfully!");
                    } else {
                        event.setCancelled(true);
                        player.sendMessage(ChatColor.RED + "[SmoothPlot] Syntax error: Example...");
                        player.sendMessage(ChatColor.RED + "1. " + this.getConfig().getString("invite_header"));
                        player.sendMessage(ChatColor.RED + "2. <friend you want to invite>");
                        player.sendMessage(ChatColor.RED + "3. <plot type-name>");
                    }
                } else {
                    event.setCancelled(true);
                    player.sendMessage(ChatColor.RED + "[SmoothPlot] You are not allowed to place this sign!");
                }
            }
        }
    }

    @EventHandler
    public void onSignHit(BlockDamageEvent event) {
        Sign sign;
        String[] lines;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        if ((material == Material.SIGN_POST || material == Material.WALL_SIGN) && (lines = (sign = (Sign)block.getState()).getLines())[0].equalsIgnoreCase(this.getConfig().getString("header"))) {
            if (lines[1].isEmpty() || lines[2].isEmpty()) {
                player.sendMessage(ChatColor.RED + "[SmoothPlot] Invalid plot-sign!");
            } else {
                ConfigurationSection cs = this.getConfig().getConfigurationSection(lines[1]);
                double cost = cs.getDouble("cost");
                if (cost == 0.0) {
                    player.sendMessage(ChatColor.YELLOW + "[SmoothPlot] The plot '" + lines[1] + "' is free!");
                } else {
                    player.sendMessage(ChatColor.YELLOW + "[SmoothPlot] The plot '" + lines[1] + "' costs " + cost + "!");
                }
            }
        }
    }
}

